###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main_loss_functions_others.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main_loss_functions_others.R".
##


###################################################
### code chunk number : Compare loss functions L(theta, a), 9 points, theta = 2
###################################################
## Compare two loss functions:
## L_2(theta, a), L_s(theta, a)

rm(list=ls(all=TRUE))

theta = 2
a = c(seq(1e-10, 2, by = 0.001), seq(2, 60, by = 10))
y1 = (a - theta)^2 # L_2(theta, a)
y2 = a / theta - log(a / theta) - 1 # L_s(theta, a)


# xp = c(1/5, 1/4, 1/3, 1/2, 1, 2, 3, 4, 5)
# ap = theta * xp
# y1p = (ap - theta)^2 # L_2(theta, a)
# y2p = ap / theta - log(ap / theta) - 1 # L_s(theta, a)


dev.new()
col = c("red", "blue")
lty = 1:2
# pch = c(4, 3, 2, 1, 0, 1, 2, 3, 4)
ylim = c(0, 30) ## range(y1, y2)
plot(a, y1, type = "n", ylim = ylim, xlab = "a", ylab = expression( L(theta[n+1], a) ))
lines(a, y1, lty = lty[1], col = col[1], lwd = 2)
lines(a, y2, lty = lty[2], col = col[2], lwd = 2)
# points(ap, y1p, pch = pch, col = col[1], lwd = 2)
# points(ap, y2p, pch = pch, col = col[2], lwd = 2)
leg.txt = c(expression( L[2](theta[n+1], a) ), expression( L[s](theta[n+1], a) ))
legend("bottomright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = "figure/L_2_L_s", type = c("pdf"))
savePlot(filename = "figure/L_2_L_s", type = c("jpg"))


####################################################
### code chunk number : Simulations: 1 theta, not good
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha =  4    ## hyperparameter
beta = 2      ## hyperparameter
v = 2         ## hyperparameter

n = 1000

theta =  rgamma(n = 1, shape = alpha, rate = beta); theta
theta
x =  rgamma(n, shape = v, rate = theta) ## the sample

#### Moment estimators


alpha_1_beta_1_v_1_EX_EX2_EX3_new = Moment_estimators_EX_EX2_EX3_new(x); alpha_1_beta_1_v_1_EX_EX2_EX3_new
 

#### MLE estimators
p = alpha_1_beta_1_v_1_EX_EX2_EX3_new
alpha_2_beta_2_v_2 = Newtons(fun = moment_fun, y = p)$root;alpha_2_beta_2_v_2


####################################################
### code chunk number : Simulations: n theta, good
####################################################
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
set.seed(2)
alpha = 4           ## hyperparameter
beta = 2            ## hyperparameter
v = 2                ## hyperparameter
n = 100000           ## sample size

theta =  rgamma(n, shape = alpha, rate = beta)
x = rgamma(n, shape = v, rate = theta) ## the sample

#### Moment estimators


alpha_1_beta_1_v_1_EX_EX2_EX3_new = Moment_estimators_EX_EX2_EX3_new(x); alpha_1_beta_1_v_1_EX_EX2_EX3_new
 
#### MLE estimators
p = alpha_1_beta_1_v_1_EX_EX2_EX3_new
alpha_2_beta_2_v_2 = Newtons(fun = moment_fun, y = p)$root; alpha_2_beta_2_v_2

